precision mediump float;

uniform sampler2D texture_diffuse;

varying vec4 v_colour;
varying vec3 v_normal;
varying vec2 v_uv;

void main()
{
    float r,g,b,y,u,v;
    vec3 yuv;

    yuv = texture2D(texture_diffuse, v_uv).rgb;
    y = yuv.r;
    u = yuv.g;
    v = yuv.b;

    y = 1.1643*(y-0.0625);
    u = u-0.5;
    v = v-0.5;

    r = y + 1.5958*v;
    g = y - 0.39173*u - 0.81290*v;
    b = y + 2.017*u;

    gl_FragColor = vec4(r,g,b,1.0);
}
